/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.toy;

import edu.princeton.toy.lang.TVirtualMachine;
import edu.princeton.toy.lang.TWord;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TSimMemPane
extends JPanel
implements Scrollable {
    private static final String CLASS_STRING = TSimMemPane.class.toString();
    public static final String RESCALE_COMMAND = CLASS_STRING + "#rescaleCommand";
    public static final String UPDATE_COMMAND = CLASS_STRING + "#updateCommand";
    public static final int MIN_SCALE = 2;
    public static final int MAX_SCALE = Integer.MAX_VALUE;
    public static final int PREFERRED_SCALE = 14;
    private static final int CACHE_SIZE = 100;
    private static final Integer[] INTEGERS = new Integer[100];
    private static final Font[] FONT_CACHE = new Font[100];
    private static final int ROW_COUNT = 16;
    private static final int ROWS_PER_BLOCK = 4;
    private static final int COLUMN_COUNT = 16;
    private static final int UNSCALED_MINIMUM_PAGE_WIDTH = 11;
    private static final int UNSCALED_PREFERRED_PAGE_WIDTH = 14;
    private static final int UNSCALED_WIDTH = 97;
    private static final int UNSCALED_HEIGHT = 21;
    private static final Dimension PREFERRED_SCROLLABLE_VIEWPORT_SIZE = new Dimension(196, 294);
    private static final Color SELECTED_CELL_BACKGROUND = new Color(204, 204, 255);
    private static final Border SELECTED_CELL_BORDER = new LineBorder(new Color(142, 142, 178), 1);
    private int scale;
    private Rectangle whiteRectangle;
    private TWord programCtr;
    private TWord oldProgramCtr;
    private TWord[] mem;
    private TWord[] oldMem;
    private JLabel unselectedCellRenderer;
    private JLabel selectedCellRenderer;
    private Listener listener;
    private TVirtualMachine virtualMachine;
    private int dragOffset;

    public TSimMemPane(TVirtualMachine virtualMachine) {
        this.setForeground(Color.black);
        if (virtualMachine == null) {
            throw new NullPointerException();
        }
        this.virtualMachine = virtualMachine;
        this.mem = new TWord[256];
        this.oldMem = new TWord[256];
        for (int ctr = 0; ctr < 256; ++ctr) {
            this.mem[ctr] = TWord.UNINITIALIZED_VALUE;
        }
        this.programCtr = TVirtualMachine.PC_START;
        this.listener = new Listener();
        virtualMachine.addChangeListener(this.listener);
        this.unselectedCellRenderer = new JLabel();
        this.unselectedCellRenderer.setOpaque(false);
        this.unselectedCellRenderer.setHorizontalAlignment(0);
        this.unselectedCellRenderer.setVerticalAlignment(0);
        this.selectedCellRenderer = new JLabel();
        this.selectedCellRenderer.setOpaque(true);
        this.selectedCellRenderer.setBackground(SELECTED_CELL_BACKGROUND);
        this.selectedCellRenderer.setBorder(SELECTED_CELL_BORDER);
        this.selectedCellRenderer.setHorizontalAlignment(0);
        this.selectedCellRenderer.setVerticalAlignment(0);
        this.scale = -1;
        this.whiteRectangle = new Rectangle();
        this.doCommand(RESCALE_COMMAND, INTEGERS[14]);
        this.setMinimumSize(new Dimension(194, 42));
        this.enableEvents(65585L);
    }

    public void setVirtualMachine(TVirtualMachine virtualMachine) {
        if (virtualMachine == null) {
            throw new NullPointerException();
        }
        if (this.virtualMachine == virtualMachine) {
            return;
        }
        this.virtualMachine.removeChangeListener(this.listener);
        virtualMachine.addChangeListener(this.listener);
        this.virtualMachine = virtualMachine;
        this.doCommand(UPDATE_COMMAND, Boolean.FALSE);
    }

    public TVirtualMachine getVirtualMachine() {
        return this.virtualMachine;
    }

    public synchronized boolean doCommand(String command, Object extraInfo) {
        if (command == RESCALE_COMMAND) {
            Font font;
            int scale = (Integer)extraInfo;
            if (scale < 2 || scale > Integer.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            if (scale == this.scale) {
                this.repaint();
                return false;
            }
            if (scale >= 100) {
                font = new Font("Monospaced", 1, (int)(0.9 * (double)scale));
            } else {
                if (FONT_CACHE[scale] == null) {
                    TSimMemPane.FONT_CACHE[scale] = new Font("Monospaced", 1, (int)(0.9 * (double)scale));
                }
                font = FONT_CACHE[scale];
            }
            this.unselectedCellRenderer.setFont(font);
            this.selectedCellRenderer.setFont(font);
            Dimension preferredSize = this.getPreferredSize();
            preferredSize.width = 99 * scale;
            this.setPreferredSize(preferredSize);
            this.scale = scale;
            this.repaint();
            return true;
        }
        if (command == UPDATE_COMMAND) {
            TWord[] tempArray = this.mem;
            this.mem = this.oldMem;
            this.oldMem = tempArray;
            this.oldProgramCtr = this.programCtr;
            this.programCtr = this.virtualMachine.getProgramCtr();
            this.virtualMachine.getMem(this.mem);
            boolean changed = this.oldProgramCtr != this.programCtr;
            for (int ctr = 0; !changed && ctr < 256; ++ctr) {
                changed = this.mem[ctr] != this.oldMem[ctr];
            }
            if (changed) {
                if (extraInfo != null && ((Boolean)extraInfo).booleanValue()) {
                    this.scrollToPc();
                } else {
                    this.repaint();
                }
            }
            return true;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void paintComponent(Graphics g) {
        Rectangle clip = g.getClipBounds();
        int scale = this.scale;
        g.setColor(this.getBackground());
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        int yOffset = this.whiteRectangle.y;
        int xOffset = this.whiteRectangle.x;
        g.setColor(Color.white);
        g.fillRect(xOffset, yOffset, this.whiteRectangle.width, this.whiteRectangle.height);
        g.setColor(Color.black);
        g.drawRect(xOffset, yOffset, this.whiteRectangle.width, this.whiteRectangle.height);
        int columnStart = Math.max(0, ((clip.x - xOffset) / scale - 1) / 6);
        int columnEnd = Math.min(15, ((clip.x + clip.width - xOffset) / scale - 1) / 6);
        Color foreground = this.getForeground();
        this.selectedCellRenderer.setForeground(foreground);
        this.unselectedCellRenderer.setForeground(foreground);
        this.unselectedCellRenderer.setBackground(this.getBackground());
        this.selectedCellRenderer.setBounds(0, 0, 5 * scale, scale);
        this.unselectedCellRenderer.setBounds(0, 0, 5 * scale, scale);
        int previousOriginX = 0;
        int previousOriginY = 0;
        short pcValue = this.programCtr.getValue();
        for (int colCtr = columnStart; colCtr <= columnEnd; ++colCtr) {
            for (int rowCtr = 0; rowCtr < 16; ++rowCtr) {
                int index = colCtr * 16 + rowCtr;
                if (index >= 256) continue;
                int currentOriginX = (1 + colCtr * 6) * scale + xOffset;
                int currentOriginY = (1 + rowCtr / 4 + rowCtr) * scale + yOffset;
                g.translate(currentOriginX - previousOriginX, currentOriginY - previousOriginY);
                if (index == pcValue) {
                    this.selectedCellRenderer.setText(TWord.HEX_PAIRS[index] + ": " + this.mem[index].toHexString(false));
                    this.selectedCellRenderer.paint(g);
                } else {
                    this.unselectedCellRenderer.setText(TWord.HEX_PAIRS[index] + ": " + this.mem[index].toHexString(false));
                    this.unselectedCellRenderer.paint(g);
                }
                previousOriginX = currentOriginX;
                previousOriginY = currentOriginY;
            }
        }
        g.translate(-previousOriginX, -previousOriginY);
    }

    @Override
    protected void processHierarchyBoundsEvent(HierarchyEvent e) {
        if (e.getID() == 1402 && e.getChanged() == this.getParent() && e.getChanged() instanceof JViewport) {
            this.deriveScale();
        }
    }

    @Override
    protected void processComponentEvent(ComponentEvent e) {
        if (e.getID() == 101) {
            this.deriveScale();
        }
        super.processComponentEvent(e);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        Container parent;
        if (e.getID() == 501 && (e.getModifiers() & 0x10) != 0 && (parent = this.getParent()) instanceof JViewport) {
            this.dragOffset = e.getX() + this.getX() + ((JViewport)parent).getViewPosition().x;
        }
        super.processMouseEvent(e);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        Container parent;
        if (e.getID() == 506 && (e.getModifiers() & 0x10) != 0 && (parent = this.getParent()) instanceof JViewport) {
            int paneWidth;
            JViewport viewport = (JViewport)parent;
            Rectangle rectangle = viewport.getViewRect();
            int newPosition = this.dragOffset - (e.getX() + this.getX());
            if (newPosition + rectangle.width > (paneWidth = this.getPreferredSize().width)) {
                newPosition = paneWidth - rectangle.width;
            }
            if (newPosition < 0) {
                newPosition = 0;
            }
            viewport.setViewPosition(new Point(newPosition, rectangle.y));
        }
        super.processMouseEvent(e);
    }

    private void deriveScale() {
        int height = this.getHeight();
        int scale = height / 21;
        if (this.getParent() instanceof JViewport) {
            int width = ((JViewport)this.getParent()).getWidth();
            scale = Math.min(scale, width / 11);
        }
        if (scale < 2) {
            scale = 2;
        }
        if (scale > Integer.MAX_VALUE) {
            scale = Integer.MAX_VALUE;
        }
        this.whiteRectangle.x = scale;
        this.whiteRectangle.y = height / 2 - 21 * scale / 2;
        this.whiteRectangle.width = scale * 97;
        this.whiteRectangle.height = scale * 21;
        if (scale >= 100) {
            this.doCommand(RESCALE_COMMAND, new Integer(scale));
        } else {
            this.doCommand(RESCALE_COMMAND, INTEGERS[scale]);
        }
    }

    public void scrollToPc() {
        Container parent = this.getParent();
        if (parent != null && parent instanceof JViewport) {
            JViewport viewport = (JViewport)parent;
            Rectangle viewRect = viewport.getViewRect();
            Dimension bounds = this.getPreferredSize();
            int selectedColumn = this.virtualMachine.getProgramCtr().getValue() / 16;
            int selectionX = selectedColumn * 6 * this.scale + this.whiteRectangle.x;
            int selectionWidth = 7 * this.scale;
            if (selectionX < viewRect.x) {
                viewRect.x = selectionX;
            }
            if (selectionX + selectionWidth > viewRect.x + viewRect.width) {
                viewRect.x = selectionX + selectionWidth - viewRect.width;
            }
            if (viewRect.x + viewRect.width > bounds.width) {
                viewRect.x = bounds.width - viewRect.width;
            }
            if (viewRect.x < 0) {
                viewRect.x = 0;
            }
            Point viewPosition = new Point(viewRect.x, viewRect.y);
            viewport.setViewPosition(viewPosition);
            parent = parent.getParent();
            if (parent != null) {
                parent.repaint();
            }
        } else {
            this.repaint();
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return PREFERRED_SCROLLABLE_VIEWPORT_SIZE;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 1: {
                return visibleRect.height / 10;
            }
            case 0: {
                return visibleRect.width / 10;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientation);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 1: {
                return visibleRect.height;
            }
            case 0: {
                return visibleRect.width;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientation);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    static {
        for (int ctr = 0; ctr < 100; ++ctr) {
            TSimMemPane.INTEGERS[ctr] = new Integer(ctr);
        }
    }

    protected class Listener
    implements ChangeListener {
        protected Listener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            TSimMemPane.this.doCommand(UPDATE_COMMAND, Boolean.TRUE);
        }
    }
}

